; K type thermocouple thermometer and thermostat

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F1459
	#include p16f1459.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_4x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 


;..................................................................................................................................
; define;
; Bank 0 RAM 
; Stored data
DIM_VAL		equ	H'20'		; dimming value
AVERG_COUNT	equ	H'21'		; ms bits for averaging of reading 1-7 (for 2 counts to 128 counts)
THERM_STAT1	equ	H'22'		; Thermostat value ls (threshold)
THERM_STAT0	equ	H'23'		; Thermostat value ms 
HYSTERESIS	equ	H'24'		; Hysteresis
HYSTERESIS0	equ	H'25'		; ms bits 
OFF_CAL		equ	H'26'		; for offset cal. +/- 7.00 degrees
HI_LO_AUT	equ	H'27'		; Thermostat high or low going threshold (bit 0 set is a high going threshold), bit 1 auto menu return
							; bit 2 linearisation on or off

; General use
TEMP		equ	H'28'		; temporary
DIV_X		equ	H'29'		; divide by X counter 
TEMPRTRE0	equ	H'2A'		; temperature as full negative to positive value ms byte
TEMPRTRE1	equ	H'2B'		; temperature as signed digital ls byte
TEMPORARY	equ	H'2C'		; temp register
HELD		equ	H'2D'		; switch held period
HELD2		equ	H'2E'		; switch held period counter #2
DISP0		equ	H'2F'		; display value ms ASCII value (returns from BCD to ASCII subroutine)
DISP1		equ	H'30'		; display value
DISP2		equ	H'31'		; display value
DISP3		equ	H'32'		; display value ls ASCII value
MENU_0		equ	H'33'		; menu to return to 0
STORE1		equ	H'34'		; delay counter
STORE2		equ	H'35'		; delay counter
SPACE_COUNT	equ	H'36'		; number of spaces on screen

; temperature readings
THERMO_SIGN	equ	H'37'		; Thermocouple positive or negative temperature (1= negative)
REF_SIGN	equ	H'38'		; reference temperature sign (1=negative)
T_COUPLE0	equ	H'39'		; Thermocouple temperature ms byte
T_COUPLE1	equ	H'3A'		; Thermocouple temperature ls byte 
THERM_POINT	equ	H'3B'		; thermocouple decimal values 0.25 deg C resolution
REFERENCE0	equ	H'3C'		; reference value as ms byte
REFERENCE1	equ	H'3D'		; reference value ls byte includes decimal point values
FAULT		equ	H'3E'		; fault (00=no fault, 01=short the Vcc, 10=short to GND, 11= open) 	
MENU		equ	H'3F'		; display MENU. Temperature display, adjust threshold, hysteresis, HI LO and adjust dimming
SW_FLG		equ	H'40'		; switch flag
TOGGLE		equ	H'41'		; toggle the full stop after TEMP on and off alternately each update
ADDITION0	equ	H'42'		; addition value ms byte
ADDITION1	equ	H'43'		; addition value ls byte
LOOPS		equ	H'44'		; increment/decrement loop
DISP_COUNT	equ	H'45'		; display update counter
AVG0		equ	H'46'		; totalising of reading counter ms byte for average
AVG1		equ	H'47'		; totalising of of reading counter byte average
AVG2		equ	H'48'		; average of reading counter ls byte
AV_COUNT	equ	H'49'		; average counter
AV_TEMP0	equ	H'4A'		; Averaged temperature as full negative to positive value ms byte
AV_TEMP1	equ	H'4B'		; Averaged temperature as signed digital ls byte
DIVX		equ	H'4C'		; divide value
AV_SIGN		equ	H'4D'		; average sign store
COUNT200	equ	H'4E'		; 200ms switch delay counter 
TEMP_COUNT	equ	H'4F'		; temperature update counter
KEEP0		equ	H'50'		; temporarily keep values ms byte
KEEP1		equ	H'51'		; temporarily keep values mid byte
KEEP2		equ	H'52'		; temporarily keep values ls byte
CHARGE		equ	H'53'		; thermostat on animation counter
BAR_GO		equ	H'54'		; thermostat animation rate counter
RLY_COUNT	equ	H'55'		; relay ON_OFF, OFF_ON counter
UPDATE		equ	H'56'		; new data update flag
WORKING0	equ	H'57'		; ms byte of temporary 
WORKING1	equ	H'58'		; ls byte of temporary
CORR_VAL	equ	H'59'		; linearity correction value for thermocouple
TEMP_REF	equ	H'5A'		; reference temporary value
LIN_RANGE	equ	H'5B'		; linearisation out of range 
 		
; Binary to BCD usage   
CNT_16		equ	H'69'		; counter for BCD conversion
BIN_0		equ	H'6A'		; binary value ms
BIN_1       equ H'6B'            
BCD_0		equ	H'6C'		; BCD MS
BCD_1		equ	H'6D'		; 
BCD_2       equ H'6E'       ; BCD LS 
TEMPN		equ H'6F'		; temporary use

; All Banks RAM
READADDMS 	equ	H'70'		; ms Byte of Program Address to read from Flash
READADDLS	equ	H'71'		; ls byte of program address to read from Flash
TEMP_VAL	equ	H'72'		; temporary value 
LOOP		equ	H'73'		; flash write memory bytes

; initial values

	org	H'1F80'; initial address from which data is stored (High Endurance Flash location)

	DA	H'0705'
; for ls byte.	; Dimming value 8-bit 0-9 for 0-255. Initial is (5 and from lookup table is D125 = ~50% duty)
; for ms byte.	; value is the averaging number of readings initially 1.
	DA  H'2000'	; Thermostat value 14-bit. Initial is (0 deg C) (for 50 deg use H20C8 (C8=D200) so 200/4 = 50.)Bit 14 set for +
	DA	H'0010'
; for ls byte.	; Hysteresis 8-bit (4 degrees initially)
	DA	H'0020'
; for ms byte.	; Bit 0 high or low threshold for heating or cooling. Initial is heating
			   	; bit 1 is menu return to main on or off. Initial is off
				; bit 2	is linearisation on or off
; for ls byte.	; offset calibration adjustment +/- 7.00 max. initial 0	


; linearisation values for thermouple. 0, 1, 2, 3, 4, 5 additions are for 0, 0.25, 0.5, 0.75, 1, 1.25 degree corrections respectively
; ie in 0.25 degree steps. Minus addition values are for bit 7 set and with positive values following (eg using 8x, 9x etc)

	org H'0EFC'; -130 to -120.5                                                                   
	DA  H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FF',H'00FE',H'00FC'	
  	;org H'0F10'; -120 to -110.5                                                                   
	DA  H'00FA',H'00F8',H'00F7',H'00F5',H'00F4',H'00F2',H'00F1',H'00EF',H'00EE',H'00ED',H'00EB',H'00EA',H'00E8',H'00E6',H'00E4',H'00E2',H'00E0',H'00DE',H'00DC',H'00DB'	
	;org H'0F24'; -110 to -100.5                                                                   
	DA  H'00DA',H'00D9',H'00D8',H'00D7',H'00D6',H'00D5',H'00D5',H'00D4',H'00D4',H'00D3',H'00D3',H'00D2',H'00D2',H'00D1',H'00D1',H'00D0',H'00D0',H'00CF',H'00CF',H'00CE'	
	;org H'0F38'; -100 to -90.5                                                                   
	DA  H'00CE',H'00CD',H'00CC',H'00CB',H'00CA',H'00C9',H'00C8',H'00C7',H'00C6',H'00C5',H'00C4',H'00C3',H'00C2',H'00C1',H'00C1',H'00C0',H'00C0',H'00BF',H'00BF',H'00BE'	
	;org H'0F4C'; -90 to -80.5                                                                   
	DA  H'00BE',H'00BD',H'00BC',H'00BB',H'00BA',H'00B9',H'00B9',H'00B8',H'00B8',H'00B7',H'00B7',H'00B6',H'00B6',H'00B5',H'00B5',H'00B4',H'00B4',H'00B3',H'00B3',H'00B2'	
	;org H'0F60'; -80 to -70.5                                                                   
	DA  H'00B2',H'00B1',H'00B0',H'00AF',H'00AE',H'00AD',H'00AC',H'00AB',H'00AA',H'00A9',H'00A8',H'00A7',H'00A6',H'00A5',H'00A4',H'00A4',H'00A3',H'00A3',H'00A2',H'00A2'	
	;org H'0F74'; -70 to -60.5                                                                   
	DA  H'00A2',H'00A1',H'00A1',H'00A0',H'00A0',H'009F',H'009F',H'009F',H'009E',H'009E',H'009D',H'009D',H'009C',H'009C',H'009B',H'009B',H'009A',H'009A',H'0099',H'0099'	
	;org H'0F88'; -60 to -50.5                                                                   
	DA  H'0099',H'0098',H'0098',H'0098',H'0097',H'0097',H'0097',H'0096',H'0096',H'0096',H'0095',H'0095',H'0095',H'0094',H'0094',H'0094',H'0093',H'0093',H'0092',H'0092'	
	;org H'0F9C'; -50 to -40.5                                                                   
	DA  H'0092',H'0091',H'0091',H'0091',H'0091',H'0090',H'0090',H'0090',H'0090',H'008F',H'008F',H'008F',H'008F',H'008E',H'008E',H'008E',H'008E',H'008D',H'008D',H'008D'	
	;org H'0FB0'; -40 to -30.5                                                                   
	DA  H'008D',H'008C',H'008C',H'008C',H'008C',H'008B',H'008B',H'008B',H'008B',H'008A',H'008A',H'008A',H'008A',H'0089',H'0089',H'0089',H'0089',H'0088',H'0088',H'0088'	
	;org H'0FC4'; -30 to -20.5                                                                
	DA  H'0088',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0086',H'0086',H'0086',H'0086',H'0086',H'0085',H'0085',H'0085',H'0085'			
	;org H'0FD8'; -20 to -10.5 
	DA  H'0085',H'0084',H'0084',H'0084',H'0084',H'0084',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082'			
	;org H'0FEC'; -10 to -0.5
	DA  H'0082',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000'			
	;org H'1000'; 0 
	DA  H'0000'
	; 0.5 to 10 
	DA 	H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0002'	
	; 10.5 to 20
	DA 	H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0003'
	; 20.5 to 30
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 30.5 to 40
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 40.5 to 50
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 50.5 to 60
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 60.5 to 70
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 70.5 to 80
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 80.5 to 90
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 90.5 to 100
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 100.5 to 110
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 110.5 to 120
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 120.5 to 130
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 130.5 to 140
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 140.5 to 150
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005'
	; 151.5 to 160
	DA 	H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006'
	; 160.5 to 170
	DA 	H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007'
	; 170.5 to 180
	DA 	H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008'
	; 180.5 to 190
	DA 	H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009'
	; 190.5 to 200
	DA 	H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A'
	; 200.5 to 210
	DA 	H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B'
	; 210.5 to 220
	DA 	H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E'
	; 220.5 to 230
	DA 	H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F'
	; 230.5 to 240
	DA 	H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010'
	; 240.5 to 250
	DA 	H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010'
	; 250.5 to 260
	DA 	H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011'
	; 260.5 to 270
	DA 	H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011'
	; 270.5 to 280
	DA 	H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011'
	; 280.5 to 290
	DA 	H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011'
	; 290.5 to 300
	DA 	H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011'
	; 300.5 to 310
	DA 	H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011'
	; 310.5 to 320
	DA 	H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010'
	; 320.5 to 330
	DA 	H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010'
	; 330.5 to 340
	DA 	H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010',H'0010'
	; 340.5 TO 350
	DA 	H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F'
	; 350.5 TO 360
	DA 	H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E'
	; 360.5 TO 370
	DA 	H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E'
	; 370.5 TO 380
	DA 	H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000D'
	; 380.5 TO 390
	DA 	H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C'
	; 390.5 TO 400
	DA 	H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B'
	; 400.5 TO 410
	DA 	H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A',H'000A'
	; 410.5 TO 420
	DA 	H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009',H'0009'
	; 420.5 TO 430
	DA 	H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008'
	; 430.5 TO 440
	DA 	H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007'
	; 440.5 TO 450
	DA 	H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005'
	; 450.5 TO 460
	DA 	H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 460.5 TO 470
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003'
	; 470.5 TO 480
	DA 	H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002'
	; 480.5 TO 490
	DA 	H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000'	
	; 490.5 TO 500
	DA 	H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081'	
	; 500.5 TO 510
	DA 	H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082'
	; 510.5 TO 520
	DA 	H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083'
	; 520.5 TO 530
	DA 	H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085'
	; 530.5 TO 540
	DA 	H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086'
	; 540.5 to 550
	DA 	H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087'
	; 550.5 to 560
	DA 	H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088'
	; 560.5 to 570
	DA 	H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A'
	; 570.5 to 580
	DA 	H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E'
	; 580.5 to 590
	DA 	H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C'
	; 590.5 to 600
	DA 	H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D'
	; 600.5 to 610
	DA 	H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E'
	; 610.5 to 620
	DA 	H'008F',H'008F',H'008F',H'008F',H'008F',H'008F',H'0090',H'0090',H'0090',H'0090',H'0090',H'0091',H'0091',H'0091',H'0091',H'0091',H'0092',H'0092',H'0092',H'0092'
	; 620.5 to 630
	DA 	H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093'
	; 630.5 to 640
	DA 	H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093'
	; 640.5 to 650
	DA 	H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093'
	; 650.5 to 660
	DA 	H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094'
	; 660.5 to 670
	DA 	H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094'
	; 670.5 to 680
	DA 	H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095'
	; 680.5 to 690
	DA 	H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096'
	; 690.5 to 700
	DA 	H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097'
	; 700.5 to 710
	DA 	H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097'
	; 710.5 to 720
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 720.5 to 730
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 730.5 to 740
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 740.5 to 750
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 750.5 to 760
	DA 	H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099'
	; 760.5 to 770
	DA 	H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099'
	; 770.5 to 780
	DA 	H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099'
	; 780.5 to 790
	DA 	H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099',H'0099'
	; 790.5 TO 800
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 800.5 TO 810
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 810.5 TO 820
	DA 	H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098',H'0098'
	; 820.5 to 830
	DA 	H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097'
	; 830.5 to 840
	DA 	H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097',H'0097'
	; 840.5 TO 850
	DA 	H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096',H'0096'
	; 850.5 TO 860
	DA 	H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095',H'0095'
	; 860.5 TO 870
	DA 	H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094'
	; 870.5 TO 880
	DA 	H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094',H'0094'
	; 880.5 TO 890
	DA 	H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0093',H'0092',H'0092',H'0092',H'0092',H'0092',H'0092',H'0092',H'0092',H'0092',H'0092'
	; 890.5 TO 900
	DA 	H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091',H'0091'
	; 900.5 TO 910
	DA 	H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090',H'0090'
	; 910.5 TO 920
	DA 	H'008F',H'008F',H'008F',H'008F',H'008F',H'008F',H'008F',H'008F',H'008F',H'008F',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E',H'008E'
	; 920.5 TO 930
	DA 	H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008D',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C',H'008C'	
	; 930.5 TO 940
	DA 	H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B',H'008B'
	; 940.5 TO 950
	DA 	H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A',H'008A'
	; 950.5 TO 960
	DA 	H'0089',H'0089',H'0089',H'0089',H'0089',H'0089',H'0089',H'0089',H'0089',H'0089',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088',H'0088'
	; 960.5 TO 970
	DA 	H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0087',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086',H'0086'
	; 970.5 TO 980
	DA 	H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0085',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084',H'0084'
	; 980.5 TO 990
	DA 	H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0083',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082',H'0082'
	; 990.5 TO 1000
	DA 	H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0081',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000',H'0000'
	; 1000.25 TO 1010
	DA 	H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0001',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002',H'0002'
	; 1010.25 TO 1020
	DA 	H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0003',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004',H'0004'
	; 1020.25 TO 1030
	DA 	H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0005',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006',H'0006'
	; 1030.25 TO 1040
	DA 	H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0007',H'0008',H'0008',H'0008',H'0008',H'0008',H'0008',H'0009',H'0009',H'0009',H'000A',H'000A'
	; 1040.25 TO 1050
	DA 	H'000A',H'000A',H'000A',H'000B',H'000B',H'000B',H'000B',H'000B',H'000B',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C',H'000C'
	; 1050.25 TO 1060
	DA 	H'000D',H'000D',H'000D',H'000D',H'000D',H'000D',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000E',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F',H'000F'
	; 1060.25 TO 1070
	DA 	H'0010',H'0010',H'0010',H'0010',H'0010',H'0011',H'0011',H'0011',H'0011',H'0011',H'0011',H'0012',H'0012',H'0012',H'0012',H'0012',H'0012',H'0012',H'0012',H'0012'
	; 1070.25 TO 1080
	DA 	H'0013',H'0013',H'0013',H'0013',H'0013',H'0014',H'0014',H'0014',H'0014',H'0014',H'0014',H'0015',H'0015',H'0015',H'0015',H'0015',H'0015',H'0015',H'0015',H'0015'
	; 1080.25 TO 1090
	DA 	H'0016',H'0016',H'0016',H'0016',H'0016',H'0017',H'0017',H'0017',H'0017',H'0017',H'0017',H'0018',H'0018',H'0018',H'0018',H'0018',H'0018',H'0018',H'0018',H'0018'
	; 1090.25 TO 1100
	DA 	H'0019',H'0019',H'0019',H'0019',H'001A',H'001A',H'001A',H'001A',H'001A',H'001A',H'001A',H'001B',H'001B',H'001B',H'001B',H'001C',H'001C',H'001C',H'001C',H'001C'
	; 1100.25 TO 1110
	DA 	H'001D',H'001D',H'001D',H'001D',H'001E',H'001E',H'001E',H'001E',H'001E',H'001F',H'001F',H'001F',H'001F',H'001F',H'0020',H'0020',H'0020',H'0020',H'0020',H'0020'
	; 1110.25 TO 1120
	DA 	H'0021',H'0021',H'0021',H'0021',H'0022',H'0022',H'0022',H'0022',H'0022',H'0022',H'0023',H'0023',H'0023',H'0023',H'0023',H'0023',H'0023',H'0023',H'0023',H'0023'
	; 1120.25 TO 1130
	DA 	H'0024',H'0024',H'0024',H'0024',H'0024',H'0025',H'0025',H'0025',H'0025',H'0025',H'0025',H'0026',H'0026',H'0026',H'0026',H'0026',H'0026',H'0026',H'0026',H'0026'
	; 1130.25 TO 1140
	DA 	H'0027',H'0027',H'0027',H'0027',H'0028',H'0028',H'0028',H'0028',H'0029',H'0029',H'0029',H'0029',H'002A',H'002A',H'002A',H'002A',H'002A',H'002A',H'002A',H'002A'
	; 1140.25 TO 1150
	DA 	H'002B',H'002B',H'002B',H'002B',H'002C',H'002C',H'002C',H'002C',H'002C',H'002D',H'002D',H'002D',H'002D',H'002E',H'002E',H'002E',H'002E',H'002E',H'002E',H'002E'
	; 1150.25 TO 1160
	DA 	H'002F',H'002F',H'002F',H'002F',H'002F',H'0030',H'0030',H'0030',H'0030',H'0030',H'0031',H'0031',H'0031',H'0031',H'0032',H'0032',H'0032',H'0032',H'0032',H'0032'
	; 1160.25 TO 1170
	DA 	H'0033',H'0033',H'0033',H'0034',H'0034',H'0034',H'0035',H'0035',H'0035',H'0035',H'0036',H'0036',H'0036',H'0036',H'0037',H'0037',H'0037',H'0038',H'0038',H'0038'
	; 1170.25 TO 1180
	DA 	H'0039',H'0039',H'0039',H'0039',H'0039',H'0039',H'003A',H'003A',H'003A',H'003A',H'003A',H'003B',H'003B',H'003B',H'003B',H'003B',H'003C',H'003C',H'003C',H'003C'
	; 1180.25 TO 1190
	DA 	H'003D',H'003D',H'003D',H'003D',H'003D',H'003D',H'003D',H'003E',H'003E',H'003E',H'003E',H'003E',H'003E',H'003F',H'003F',H'003F',H'003F',H'0040',H'0040',H'0040'
	; 1190.25 TO 1200
	DA 	H'0040',H'0041',H'0041',H'0042',H'0042',H'0042',H'0043',H'0043',H'0044',H'0044',H'0045',H'0045',H'0046',H'0046',H'0047',H'0047',H'0047',H'0048',H'0048',H'0048'
	; 1200.25 TO 1210
	DA 	H'0049',H'0049',H'0049',H'004A',H'004A',H'004A',H'004B',H'004B',H'004B',H'004C',H'004C',H'004C',H'004D',H'004D',H'004E',H'004E',H'004F',H'004F',H'0050',H'0050'
	; 1210.25 TO 1220
	DA 	H'0051',H'0051',H'0051',H'0052',H'0052',H'0052',H'0053',H'0053',H'0053',H'0054',H'0054',H'0054',H'0055',H'0055',H'0056',H'0056',H'0057',H'0057',H'0058',H'0058'
	; 1220.25 TO 1230
	DA 	H'0059',H'0059',H'0059',H'005A',H'005A',H'005B',H'005B',H'005B',H'005C',H'005C',H'005C',H'005D',H'005D',H'005E',H'005E',H'005F',H'005F',H'0060',H'0060',H'0060'
	; 1230.25 TO 1240
	DA 	H'0061',H'0061',H'0061',H'0062',H'0063',H'0063',H'0064',H'0064',H'0065',H'0065',H'0066',H'0066',H'0067',H'0068',H'0069',H'005A',H'005B',H'006B',H'006C',H'006C'
	; 1240.25 TO 1250
	DA 	H'006D',H'006D',H'006D',H'006D',H'006D',H'006E',H'006E',H'006E',H'006E',H'006E',H'006F',H'006F',H'006F',H'006F',H'0070',H'0070',H'0070',H'0070',H'0070',H'0070'
	; 1250.25 TO 1260
	DA 	H'0071',H'0071',H'0071',H'0071',H'0071',H'0072',H'0072',H'0072',H'0072',H'0072',H'0073',H'0073',H'0073',H'0073',H'0074',H'0074',H'0074',H'0074',H'0074',H'0074'
	; 1260.25 TO 1270
	DA 	H'0075',H'0075',H'0075',H'0075',H'0075',H'0076',H'0076',H'0076',H'0076',H'0076',H'0076',H'0077',H'0077',H'0077',H'0077',H'0078',H'0078',H'0078',H'0078',H'0078'
	; 1270.25 TO 1280
	DA 	H'0079',H'0079',H'0079',H'007A',H'007A',H'007A',H'007B',H'007B',H'007B',H'007B',H'007C',H'007C',H'007C',H'007C',H'007D',H'007D',H'007D',H'007E',H'007E',H'007E'
	; 1280.25 TO 129
	DA 	H'007F',H'007F',H'007F',H'007F'
	
;..............................................................................................................................

	org		0
	goto	MAIN
	org     4				; interrupt vector 0004h
	clrf	PCLATH	
	bsf		PCLATH,3		; page change to =>H800
	goto	INTERRUPT

;......................................................................
; dimming lookup table

DIMMER ; Brightness
	addwf 	PCL,f			; lookup table for PWM brightness control
; 0-10 values using 25.5 on average each step for 0-255
;
	retlw	D'0'			; OFF 0%
	retlw	D'25'			; 1 bar on bargraph (PWM 25/255 duty)
	retlw	D'51'			; 2 bars
	retlw	D'76'			; 3
	retlw	D'102'			; 4
	retlw	D'127'			; 5 50% duty
	retlw	D'153'			; 6
	retlw	D'178'			; 7
	retlw	D'204'			; 8
	retlw	D'229'			; 9 bars
	retlw	D'255'			; 10 bars 100% duty

SUM_LOOK; averaging sum 
	addwf 	PCL,f
	retlw	D'3'			; 1  averaging over 2 counts
	retlw	D'5'			; 2  averaging over 4 counts
	retlw	D'9'			; 3					8
	retlw	D'17'			; 4					16
	retlw	D'33'			; 5 				32
	retlw	D'65'			; 6					64
	retlw	D'129'			; 7	 averaging over 128 counts
	retlw	D'2'			; 8	 no averaging
;.......................................................................
	org		H'0800'	; page 2
INTERRUPT
; interrupt to check switch closure. Adjust values and store.
; run timer at Timer1 overflow rate =100ms or 10ms depending on SW_FLG
	movlb	D'0'			; bank 0
	bcf		PIR1,TMR1IF		; timer 1 overflow flag cleared
; increase MENU_0 counter 
; if overrange then clear MENU
	incf	DIV_X,f			; divide down
	btfsc	HI_LO_AUT,1		; if set then auto menu return
	btfss	DIV_X,0
	goto	DISP_T_UPDATE	
	incfsz	MENU_0,f		; increase when DIV_X bit is set
	goto	DISP_T_UPDATE
	clrf	MENU
	clrf	MENU_0			; set for 5s overall (with DIV_X /2)
DISP_T_UPDATE
; temperature update rate counter
	incfsz	TEMP_COUNT,f	; temperature update counter for temperature
	goto	DRC
	movlw	H'FF'
	movwf	TEMP_COUNT
DRC
; display update rate counter
	incfsz	DISP_COUNT,f	; display update counter for temperature
	goto	STOP_T
	movlw	H'FF'
	movwf	DISP_COUNT

STOP_T	; stop timer 
	bcf		T1CON,TMR1ON	; timer1 stopped

; pre-load (D65536 - D12,50)=D64,286  to timer 1 so it counts over 10ms
	movlw	H'FB'			; D64,286 = H'FB1E' 
	movwf	TMR1H			; ms byte
	movlw	H'20'			; compensated by +2 for timer off period 
	movwf	TMR1L			; ls byte
	bsf		T1CON,TMR1ON	; timer1 re-started
; use count of ten to increase switch check after 200ms if SW_FLG is not 0
	movf	SW_FLG,w
	btfsc	STATUS,Z		; if zero use fast rate
	goto	FAST_RATE
	movf	COUNT200,w
	btfsc	STATUS,Z		; if zero fast rate
	goto	FAST_RATE
	decfsz	COUNT200,f
	retfie					; decrease until zero for 200ms rate
FAST_RATE
; check switches
	btfss	PORTC,0			; S1 closed if low
	goto	SW1
	btfss	PORTA,1			; S2 closed if low
	goto	SW2
	btfss	PORTA,0			; S3 closed if low
	goto	SW3
; no switch so clear counters and flag set previously for a closed switch
; if SW_FLG,2 or SW_FLG,3 are set then write to flash
	btfsc	SW_FLG,2
	call	STORE			; write to Flash
	btfsc	SW_FLG,3
	call	STORE			; write to Flash
	clrf	SW_FLG			; switch flag cleared
	clrf	HELD			; switch held closed period counter #1
	clrf	HELD2			; switch held closed period counter #2
	clrf	COUNT200
	retfie

SW1 ; menu switch
; counter to return to MENU=0 after no switch press
	clrf	MENU_0			; set for 5s overall (with DIV_X /2)
; S1 (RC0) Menu (SW_FLG,1)
; if SW_FLG,1 is set do changes slower
	btfss	SW_FLG,1
	incf	MENU,f			; increase MENU	at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment MENU
	goto	CK_MENU
	clrf	HELD			; switch closure time reset
	incf	MENU,f			; increase when HELD value reached
CK_MENU
	movf	MENU,w
	sublw	D'10'
	btfss	STATUS,C		; if over MENU x then clear
	clrf	MENU
	
	movlw	B'00000010'		; set SW_FLG,1 and clear bits 2 and 3 for S2 and S3	
	movwf	SW_FLG			; set S1 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
	
SW2 ;UP 
; counter to return to MENU=0 after no switch press
	clrf	MENU_0			; set for 5s overall (with DIV_X /2)
;(RA1)(SW_FLG,2)
; increase at pressing and if held down
; another counter for faster rate (10s) instead of 1s (depends on resolution also)
; check MENUs that have values or settings that can be altered

	movf	MENU,w
	btfsc	STATUS,Z
	retfie				; return if MENU 0 (temperature reading so no up or down)
	
	movf	MENU,w
	xorlw	D'4'		; dimming
	btfsc	STATUS,Z	
	goto	DIM_UP
	movf	MENU,w
	xorlw	D'3'		; hysteresis
	btfsc	STATUS,Z	
	goto	HYST_UP
	movf	MENU,w
	xorlw	D'1'		; offset
	btfsc	STATUS,Z	
	goto	OFF_UP
	movf	MENU,w
	xorlw	D'5'		; averaging
	btfsc	STATUS,Z	
	goto	AVG_UP
	movf	MENU,w
	xorlw	D'6'		; HI/LO
	btfsc	STATUS,Z	
	goto	HIGH_LOW
	movf	MENU,w
	xorlw	D'2'		; thermostat
	btfsc	STATUS,Z
	goto	THERM_UP
	movf	MENU,w
	xorlw	D'7'		; MENU return on/off
	btfsc	STATUS,Z
	goto	MENU_RETURN
	movf	MENU,w
	xorlw	D'8'		; linearisation on/off
	btfsc	STATUS,Z
	goto	LIN_ON_OFF
	retfie				; none of those selected

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
OFF_UP
; if SW_FLG,2 is set do changes slower
	btfss	SW_FLG,2
	goto	INC_OFF			; increase offset at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	retfie	
	clrf	HELD			; switch closure time reset
INC_OFF
	incf	OFF_CAL,f		; increase value at switch press 
	movf	OFF_CAL,w		; stop at 7 degrees. bit5 is sign. next are the before DP. last 2 after dp.
	sublw	D'60'			; 111100
	movf	OFF_CAL,w
	btfss	STATUS,C		; if over then stop increment
	movlw	D'60'
	movwf	OFF_CAL
	movlw	B'00000100'		; set SW_FLG,2 and clear bits 1 and 3 for S1 and S3	
	movwf	SW_FLG			; set S2 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
THERM_UP
; increase THERM_STAT0 and THERM_STAT1
; if SW_FLG,2 is set do changes slower
	btfss	SW_FLG,2
	goto	INC_THERM
	movf	HELD2,w
	sublw	D'40'
	btfss	STATUS,C
	goto	ADD_MORE_THERM1		; faster
	movf	HELD2,w
	sublw	D'20'
	btfss	STATUS,C
	goto	ADD_MORE_THERM		; fast
	incf	HELD2,f
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment thermostat value
	retfie
	clrf	HELD			; switch closure time reset
INC_THERM
	movlw	D'1'
ADD1
	addwf	THERM_STAT1,f
	btfsc	STATUS,C
	incf	THERM_STAT0,f
	btfss	THERM_STAT0,6
	goto	UP_CONT1
	movlw	H'FF'
	movwf	THERM_STAT0		; stop at 2047
	movwf	THERM_STAT1

UP_CONT1
	movlw	B'00111111'
	andwf	THERM_STAT0,f	; only using 14-bits
	movlw	B'00000100'		; set SW_FLG,2 and clear bits 1 and 3 for S1 and S3	
	movwf	SW_FLG			; set S2 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
ADD_MORE_THERM
	incf	HELD2,f
	movlw	D'4'			; increase faster when HELD2 value reached
	; increase when HELD2 value reached
	goto	ADD1
ADD_MORE_THERM1
	movlw	D'64'			; increase faster when HELD2 value reached
	;increase when HELD2 value reached
	goto	ADD1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DIM_UP
; if SW_FLG,2 is set do changes slower
	btfss	SW_FLG,2
	goto	INC_DIM			; increase dimming value at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	retfie	
	clrf	HELD			; switch closure time reset
INC_DIM
	incf	DIM_VAL,f		; increase dimming value at switch press 
	movf	DIM_VAL,w		; stop at 10
	sublw	D'10'
	movf	DIM_VAL,w
	btfss	STATUS,C		; if over then stop increment
	movlw	D'10'
	movwf	DIM_VAL

UPDATE_DIM	
; update dimming for PWM
	movf	DIM_VAL,w
	bcf		PCLATH,3		; page 0
	call	DIMMER			; lookup table for 10-step dimming
	bsf		PCLATH,3		; page
	movlb	D'12'			; Bank 12
	movwf	PWM1DCH			; duty cycle 
	movlb	D'0'			; bank 0
	movlw	B'00000100'		; set SW_FLG,2 and clear bits 1 and 3 for S1 and S3	
	movwf	SW_FLG			; set S2 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AVG_UP

; if SW_FLG,2 is set do changes slower
	btfss	SW_FLG,2
	goto	INC_AV			; increase averaging value at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	retfie	
	clrf	HELD			; switch closure time reset
INC_AV
	incf	AVERG_COUNT,f	; increase averaging value at switch press 
	movf	AVERG_COUNT,w	; stop at 7
	sublw	D'7'
	movf	AVERG_COUNT,w
	btfss	STATUS,C		; if over then stop increment, return to 0
	movlw	D'0'
	movwf	AVERG_COUNT
	movlw	B'00000100'		; set SW_FLG,2 and clear bits 1 and 3 for S1 and S3	
	movwf	SW_FLG			; set S2 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	clrf	AV_COUNT
	clrf	AVG0
	clrf	AVG1
	clrf	AVG2
	retfie
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
HYST_UP ;
; if SW_FLG,2 is set do changes slower
	btfss	SW_FLG,2
	goto	INC_HYST		; increase HYSTERESIS at switch press unless switch flag is set
	movf	HELD2,w
	sublw	D'10'
	btfss	STATUS,C
	goto	INC_HYST
	incf	HELD2,f
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	goto	CK_HYST
	clrf	HELD			; switch closure time reset
INC_HYST
	incf	HYSTERESIS,f	; increase at switch press and when HELD value reached
CK_HYST
; limit value
	movf	HYSTERESIS,w	; stop at 60 deg C. That is 200 when considering  (60 x 4 =240)
	sublw	D'240'
	movf	HYSTERESIS,w	; get hysteresis
	btfss	STATUS,C		; if over then clear
	movlw	D'240'			; set at 63 max
	movwf	HYSTERESIS
	
	movlw	B'00000100'		; set SW_FLG,2 and clear bits 1 and 3 for S1 and S3	
	movwf	SW_FLG			; set S2 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SW3 ; down
; counter to return to MENU=0 after no switch press
	clrf	MENU_0			; set for 5s overall (with DIV_X /2)
; (RA0) (SW_FLG,3)
; decrease at pressing and if held down
; another counter for faster rate (10s) instead of 1s (depends on resolution also)
; check MENUs that have values or settings that can be altered

	movf	MENU,w
	btfsc	STATUS,Z
	retfie				; return if MENU 0 (temperature reading)
	xorlw	D'4'		; dimming
	btfsc	STATUS,Z	
	goto	DIM_DN
	movf	MENU,w
	xorlw	D'3'		; hysteresis
	btfsc	STATUS,Z	
	goto	HYST_DN
	movf	MENU,w
	xorlw	D'1'		; offset
	btfsc	STATUS,Z	
	goto	OFF_DN
	movf	MENU,w
	xorlw	D'5'		; averaging
	btfsc	STATUS,Z	
	goto	AVG_DN
	movf	MENU,w
	xorlw	D'6'		; HI/LO Heat/cool
	btfsc	STATUS,Z	
	goto	HIGH_LOW
	movf	MENU,w
	xorlw	D'2'		; thermostat
	btfsc	STATUS,Z
	goto	THERM_DN
	movf	MENU,w
	xorlw	D'7'		; Menu return on or off
	btfsc	STATUS,Z
	goto	MENU_RETURN
	movf	MENU,w
	xorlw	D'8'		; linearisation on/off
	btfsc	STATUS,Z
	goto	LIN_ON_OFF
	retfie				; none of above selected
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
OFF_DN
; if SW_FLG,3 is set do changes slower
	btfss	SW_FLG,3
	goto	DEC_OFF			; decrease value at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	retfie	
	clrf	HELD			; switch closure time reset
DEC_OFF
	movf	OFF_CAL,w
	sublw	B'00000100'		; stop at -7 degrees
	btfsc	STATUS,C		; if less no decrease
	retfie
	decf	OFF_CAL,f		; decrease value at switch press 

	movlw	B'00001000'		; set SW_FLG,3 and clear bits 1 and 2 for S1 and S2	
	movwf	SW_FLG			; set S3 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
THERM_DN
; decrease THERM_STAT0 and THERM_STAT1
; if SW_FLG,3 is set do changes slower
	btfss	SW_FLG,3
	goto	DEC_THERM
	movf	HELD2,w
	sublw	D'40'
	btfss	STATUS,C
	goto	REDUCE_MORE_THERM
	movf	HELD2,w
	sublw	D'20'
	btfss	STATUS,C
	goto	REDUCE_MORE_THERMO
	incf	HELD2,f
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment thermostat value
	retfie
	clrf	HELD			; switch closure time reset
DEC_THERM
	movlw	D'1'			; decrease when HELD value reached

DEC_LOOP
	subwf	THERM_STAT1,f
	btfss	STATUS,C
	decf	THERM_STAT0,f
; stop at 0
	btfss	THERM_STAT0,7	; if set then beyond 0
	goto	DEC_CONT
	clrf	THERM_STAT1
	incf	THERM_STAT1,f
	clrf	THERM_STAT0
DEC_CONT
	movlw	B'00111111'
	andwf	THERM_STAT0,f		; only using 14-bits
	movlw	B'00001000'		; set SW_FLG,3 and clear bits 1 and 2 for S1 and S2	
	movwf	SW_FLG			; set S3 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
REDUCE_MORE_THERMO
	incf	HELD2,f
	movlw	D'4'			; decrease when HELD2 value reached
	goto	DEC_LOOP
REDUCE_MORE_THERM
	movlw	D'32'			; decrease when HELD2 value reached
	goto	DEC_LOOP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
DIM_DN
; if SW_FLG,3 is set do changes slower
	btfss	SW_FLG,3
	goto	DEC_DIM			; decrease dimming value at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	retfie	
	clrf	HELD			; switch closure time reset
DEC_DIM
	movf	DIM_VAL,w
	btfsc	STATUS,Z		; if zero no decrease
	retfie
	decf	DIM_VAL,f		; decrease dimming value at switch press 
	goto	UPDATE_DIM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AVG_DN
	
; if SW_FLG,3 is set do changes slower
	btfss	SW_FLG,3
	goto	DEC_AV			; decrease averaging value at switch press unless switch flag is set
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	retfie	
	clrf	HELD			; switch closure time reset
DEC_AV
	movf	AVERG_COUNT,w
	btfsc	STATUS,Z		; if zero set at 7
	goto	SET7
	decf	AVERG_COUNT,f	; decrease averaging value at switch press 

E7	movlw	B'00001000'		; set SW_FLG,3 and clear bits 1 and 2 for S1 and S2	
	movwf	SW_FLG			; set S3 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	clrf	AV_COUNT
	clrf	AVG0
	clrf	AVG1
	clrf	AVG2
	retfie
SET7
	movlw	D'7'
	movwf	AVERG_COUNT
	goto	E7

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
HYST_DN ;
	movf	HYSTERESIS,w
	btfsc	STATUS,Z		; if zero bypass
	retfie

; if SW_FLG,3 is set do changes slower
	btfss	SW_FLG,3
	goto	DEC_HYST		; decrease HYSTERESIS at switch press unless switch flag is set
	movf	HELD2,w
	sublw	D'10'
	btfss	STATUS,C
	goto	DEC_HYST
	incf	HELD2,f
	incf	HELD,f
	movf	HELD,w
	sublw	D'5'			; value x 100ms rate
	btfsc	STATUS,C		; if over, increment 
	goto	CK_HYST_D
	clrf	HELD			; switch closure time reset
DEC_HYST
	decf	HYSTERESIS,f	; decrease when switch pressed and when HELD value reached
CK_HYST_D
	movlw	B'00001000'		; set SW_FLG,3 and clear bits 1 and 2 for S1 and S2	
	movwf	SW_FLG			; set S3 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
HIGH_LOW; toggle bit 0

	btfsc	SW_FLG,2		; switch up flag. If set bypass change
	retfie
	btfsc	SW_FLG,3		; switch down flag. If set bypass change
	retfie

	btfss	HI_LO_AUT,0
	goto	HI_LO_BIT
	bcf		HI_LO_AUT,0
	goto	WAIT_SWITCH
HI_LO_BIT	
	bsf		HI_LO_AUT,0

WAIT_SWITCH
	bsf		SW_FLG,2		; switch flag S2
	bsf		SW_FLG,3 		; S3 flag
	movlw	D'20'
	movwf	COUNT200		; 200ms delay
	retfie					; end interrupt

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

LIN_ON_OFF ; linearisation on or off 
; toggle bit 2
	btfsc	SW_FLG,2		; switch up flag. If set bypass change
	retfie
	btfsc	SW_FLG,3		; switch down flag. If set bypass change
	retfie

	btfss	HI_LO_AUT,2
	goto	LIN_BITS
	bcf		HI_LO_AUT,2
	goto	WAIT_SWITCH
LIN_BITS	
	bsf		HI_LO_AUT,2
	goto	WAIT_SWITCH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MENU_RETURN ; menu return to zero on/off
; toggle bit 1
	btfsc	SW_FLG,2		; switch up flag. If set bypass change
	retfie
	btfsc	SW_FLG,3		; switch down flag. If set bypass change
	retfie

	btfss	HI_LO_AUT,1
	goto	RET_BITS
	bcf		HI_LO_AUT,1
	goto	WAIT_SWITCH
RET_BITS	
	bsf		HI_LO_AUT,1
	goto	WAIT_SWITCH
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
; keep within page 2 address

STORE ; store values from RAM to Flash
	clrf	SW_FLG		; switch flag cleared so storage occurs once even if two switch flags are set
; store into flash memory from RAM (DIM_VAL, THERM_STAT0 THERMO_STAT1, HYSTERESIS, HI_LO_AUT and DIM_VAL).
; Stores in the correct ID location
; Start of Flash high endurance location	
	movlw	H'1F'		; ms address byte (H1F80)
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte

; start of RAM
	movlw	H'20'
	movwf	FSR0H
	movlw 	H'00'
	movwf	FSR0L

; write to data memory
WRITE
	clrf	 LOOP			; counter

; load write latches
	movlb	 D'03'			; bank 3
	movf	 READADDMS,W	; Load upper 6 bits of address boundary			
	movwf	 PMADRH ;
	movf	 READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	 B'11110000'	; clear ls bits to start of ID memory
	movwf	 PMADRL ;

; erase first
	bcf		 PMCON1,CFGS 	; Not configuration space
	bsf		 PMCON1,FREE 	; Specify an erase operation
	bsf		 PMCON1,WREN 	; Enable writes
	movlw	 H'55'			; Start of required write sequence:
	movwf	 PMCON2 		; Write 55h
	movlw	 H'AA' ;
	movwf	 PMCON2 		; Write AAh
	bsf		 PMCON1,WR 		; Set WR bit to begin erase
	nop					 	; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	 
	bcf		 PMCON1,WREN ; Disable writes

; load latches
	movf	 READADDMS,W	; Load upper 6 bits of  address boundary			
	movwf	 PMADRH ;
	movf	 READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	 B'11110000'	; clear ls bits to start of ID memory
	movwf	 PMADRL ;

	bcf		PMCON1,CFGS		; Not configuration space
	bsf		PMCON1,WREN	 	; Enable writes
	bsf		PMCON1,LWLO 	; Only Load Write Latches

LOOPW
	moviw	FSR0++ 			; Load first data byte into lower
	movwf	PMDATL ;
	moviw	FSR0++	 		; Load second data byte into upper
	movwf	PMDATH ;

	movf	LOOP,w		 	; Check  lower bits of address
	xorlw	0x08			; Check if we're on the last of addresses
	btfsc	STATUS,Z 		; Exit if last of words,
	goto	START_WRITE ;

	movlw	 H'55'		 	; Start of required write sequence:
	movwf	 PMCON2 		; Write 55h
	movlw	 H'AA' ;
	movwf	 PMCON2			; Write AAh
	bsf		 PMCON1,WR 		; Set WR bit to begin write
	nop					 	; nop instructions are forced as processor loads program memory write latches
	nop ;
	incf	 PMADRL,f	 	; Still loading latches Increment address
	incf	 LOOP,f
	goto	 LOOPW

START_WRITE ; write
	bcf		PMCON1,LWLO	; No more loading latches - Start Flash program
; memory write
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop						; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	  
	bcf		PMCON1,WREN 	; Disable writes
	movlb	 D'0'			; bank 0

	return
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; PAGE1 address

	org H'020'	
MAIN

; initialise functions

; set inputs/outputs
	movlb	D'2'			; latch, bank 2
	clrf	LATA
	clrf	LATB
; CS high (RC4); SCK low (RC6)
	movlw	B'00010000'
	movwf	LATC

;USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
	
; weak pullups off
	movlb	D'4'		; bank4	WPUA/B
	clrf	WPUA
	clrf	WPUB
	
; set I/O
	movlb	D'1'		; bank1	TRISA/B/C
	movlw   B'00101011'	; I/O (RA inputs and outputs)
	movwf   TRISA		; port A data direction register
	movlw	B'00000000'	; I/O (RB inputs and outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'00000001'	; I/O (RC inputs and outputs)
	movwf	TRISC		; port C data direction 
; options
	movlw	B'10000111'	; weak pullups set via WPUA/B TMR0/256
	movwf	OPTION_REG	; 
; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C
	movlw	B'00000000'	; 
	movwf	ANSELA
	movlw	B'00000000' ;
	movwf	ANSELB
	movlw	B'00000000'	; 
	movwf	ANSELC
; oscillator
	movlb	D'1'		; bank 1	
	movlw	B'00110100'	; for 4MHz;
	movwf	OSCCON		; osc
; timer2 set
	movlb	D'0'		; bank0	
	movlw	D'254'		; 
	movwf	PR2			; 
	movlw	B'00000101'	; /4 for 1024us (976Hz) for PWM dimming 
	movwf	T2CON
; timer1 set
	movlw	B'00110001'	; was 4MHz/4/8;  period 8us. 
	movwf	T1CON

; PWM set
	movlb	D'12'		; bank12  PWM	
	movlw	B'11100000'	; set PWM mode
	movwf	PWM1CON		; enable PWM1 operation
	clrf	PWM1DCL
	clrf	PWM1DCH		; 0 duty cycle (use PR2/2  for ~ 50% duty cycle) 

; initial conditions
	movlb	D'0'		; bank0
	clrf	MENU		; power up display menu = 0
	clrf	SW_FLG		; switch flag
	clrf	HELD		; switch held timer
	bsf		AV_SIGN,0	; plus value for cleared averaging beginning
	clrf 	AVG0		; totalising of reading counter ms byte for average
	clrf	AVG1		; totalising of reading counter byte average
	clrf	AVG2		; average of reading counter ls byte
	clrf 	AV_COUNT	; average counter
	movlw	H'FF'
	movwf	AV_TEMP0	; Averaged temperature as full negative to positive value ms byte
	movwf	AV_TEMP1	; Averaged temperature as signed digital ls byte
	clrf	COUNT200	; 200ms delay counter for switches
	clrf	RLY_COUNT	; relay ON_OFF, OFF_ON counter
  	clrf	UPDATE		; new data update flag
	
; read values from flash
; DIM value for display backlight
	movlw	H'1F'		; ms address byte (H1F80)
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	DIM_VAL
	call	DIMMER		; lookup table for 10-step dimming
	movlb	D'12'		; Bank 12
	movwf	PWM1DCH		; duty cycle 
	movlb	D'0'		; bank 0
; Average count
; found in TEMP_VAL from above read
	movf	TEMP_VAL,w
	movwf	AVERG_COUNT	
; Thermostat value 14-bit
	incf	READADDLS,f	; next value
	call	READ
	movwf	THERM_STAT1	; ls byte
	movf	TEMP_VAL,w	; ms bits
	movwf	THERM_STAT0	; ms bits
; Hysteresis 8-bit
	incf	READADDLS,f	; next value
	call	READ
	movwf	HYSTERESIS	; 
; HI or LO and Auto return for Thermostat heating or cooling going threshold (using bit 0). Bit 2 is for resolution, 1 auto menu return
; ls byte for offset
	incf	READADDLS,f	; next value
	call	READ
	movwf	OFF_CAL		; offset adjustment
; found in TEMP_VAL from above read
	movf	TEMP_VAL,w	; ms bits
	movwf	HI_LO_AUT

; delay start
DELAY_START	
	call	DELAYms

; initialise LCD
	movlw	H'FF'		; start up delay
	call	DELAYX
	call	INIT_LC	
	movlw	H'FF'		; start up delay
	call	DELAYX
	call	INIT_LC
	call	DELAYms
	call	INIT_LC
	call	DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call	LOAD
	movlw	B'00001100'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00001100'	; blinking off, cursor off
	call	LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call	LOAD		; 
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX
	call	CHARACTR_GEN	; special characters setup

ALLOW_INTERUPTS
; interrupts
	movlb	D'1'
	bsf		PIE1,TMR1IE		; enable timer1 interrupt
	movlb	D'0'
	bcf		PIR1,TMR1IF		; flag clear
	bsf		INTCON,PEIE		; enable peripheral interrupts
	bsf		INTCON,GIE		; interrupts off
	goto	DATA31

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; subroutine
INIT_CLOCK
; CS high (RC4); SCK low (RC6) initially. CS low to start data retrieve. Data clocked each SCK high into RA5.
	movlb	D'2'		; latch, bank 2
	bcf		LATC,4		; CS low
	nop
	nop
	nop
CLOCK_HI
;  Data clocked each SCK high into RA5.
	movlb	D'2'		; latch, bank 2
	bsf		LATC,6		; clock high
	movlb	D'0'		; bank 0
	return
CLOCK_LO
	movlb	D'2'		; latch, bank 2
	bcf		LATC,6		; clock low
	movlb	D'0'		; bank 0
	return	

;....................................................................
; read temperature and error codes

DATA31
	movf	TEMP_COUNT,w;counter is incremented in interrupt each 10ms
	sublw	D'11'		; ensure >100ms between reads
	btfsc	STATUS,C	; if >11 then read data
	goto	DATA31		; wait
	clrf	TEMP_COUNT

	call	INIT_CLOCK	; clocking after CS low
; D31. Thermocouple sign bit (bit 31)
	clrf	THERMO_SIGN	; Thermocouple positive or negative temperature (1= negative)
	btfsc	PORTA,5		; 
	bsf		THERMO_SIGN,0; set bit 0 if negative temperature
	call	CLOCK_LO	; clock low	

; D30 to D20. Thermocouple temperature bits 30 to 20 (11 bits),D18 and D19 decimal values
	clrf	T_COUPLE0	; Thermocouple temperature ms byte
	clrf	T_COUPLE1	; Thermocouple temperature ls byte
	movlw	D'13'		; 13 bits
	movwf	TEMPN		; temporary use (clocking counter)
T_LOOP
	call	CLOCK_HI	; next data
	bcf		STATUS,C	; carry clear
	btfsc	PORTA,5		; 
	bsf		STATUS,C	; set carry when data set
	rlf		T_COUPLE1,f	; shift left with carry
	rlf		T_COUPLE0,f	; shift left
	call	CLOCK_LO	; clock low
	decfsz	TEMPN,f		; keep loop until data ended
	goto	T_LOOP

	call	AVG_PROCESS	; do averaging and processing each time

; D17 No data, so clock through
NO_D17
	call	CLOCK_HI	; next data
	call	CLOCK_LO	; clock low

; D16 is for FAULT. 
	call	CLOCK_HI	; clocking 
	call	CLOCK_LO	; clock low	

; D15 is REF_SIGN, reference temperature sign (1=negative)
	call	CLOCK_HI	; clocking 
	clrf	REF_SIGN	
	btfsc	PORTA,5		; 
	bsf		REF_SIGN,0	; bit 0 is set
	call	CLOCK_LO	; clock low	

; D14 -D8 is reference temperature 7-bits, D7-D4 is decimal point values 
; reference decimal values 0.0625 deg C resolution 4-bits(only use 2 ms bits)
	clrf	REFERENCE0	; temperature
	clrf	REFERENCE1 
	movlw	D'9'		; 9 bits
	movwf	TEMPN		; temporary use (clocking counter)
REF_T_LP
	call	CLOCK_HI	; next data
	bcf		STATUS,C	; carry clear
	btfsc	PORTA,5		; 
	bsf		STATUS,C	; set carry when data set
	rlf		REFERENCE1,f	; shift left with carry
	rlf		REFERENCE0,f
	call	CLOCK_LO	; clock low
	decfsz	TEMPN,f		; keep loop until data ended
	goto	REF_T_LP
 
; clock through D3,D4 ls resolution values(not used)
; 
	movlw	D'2'		; 2 bits
	movwf	TEMPN		; temporary use (clocking counter)
REF_PT_LP
	call	CLOCK_HI	; next data
	nop
	nop
	call	CLOCK_LO	; clock low
	decfsz	TEMPN,f		; keep loop until data ended
	goto	REF_PT_LP

;...............................................................	
; D2, D1 and D0 are Fault flags
FAULT_DATA ; read D2, D1 and D0 for type of fault 
	clrf	FAULT 
	movlw	D'4'		; 4 bits (D3 reads as 0)
	movwf	TEMPN		; temporary use (clocking counter)
FLT
	call	CLOCK_HI	; next data
	bcf		STATUS,C	; carry clear
	btfsc	PORTA,5		; 
	bsf		STATUS,C	; set carry when data set
	rlf		FAULT,f		; shift left with carry
	call	CLOCK_LO	; clock low
	decfsz	TEMPN,f		; keep loop until data ended
	goto	FLT

; CS high (RC4)to allow temperature measurements 
	movlb	D'2'		; latch, bank 2
	bsf		LATC,4		; CS high
	movlb	D'0'		; bank 0

; DELAY required for repeated temperature measurements but is catered for by delays in display writes and following code
; taking time to execute
	
; **************************************************************
SHOW_ERR
; Show errors if FAULT
	movf	FAULT,w
	btfsc	STATUS,Z
	goto	THRES		; do threshold comparison

; Switch RELAY off. relay counter provides glitch protection as two off signals are required before relay goes off

; relay on/off logic for an off.
; 1. if already off, clear RLY_COUNT

	btfss	PORTA,4
	goto	RLY1
; 2. if on, increment counter (RLY_COUNT)
	incf	RLY_COUNT,f 
; when bit 2 is set (3 counts later), switch off relay and clear RLY_COUNT
	btfss	RLY_COUNT,2
	goto	WAIT_RLY1	; do not switch off or clear RLY_COUNT

; relay off
	movlb	D'2'		; latch, bank 2
	bcf		LATA,4		; relay off
	movlb	D'0'		; bank 0
RLY1
	clrf	RLY_COUNT
WAIT_RLY1

	movf	MENU,w		; if MENU=0 show fault
	btfss	STATUS,Z
	goto	THRES		; continue
; Faults. 
; Write THERMOCOUPLE
	movlw	H'80'		; address line 1 pos 0
	call	LOAD		; curser position
	movlw	A'T'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'C'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'P'
	call	DRV_LCD
	movlw	A'L'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	D'16'		; clear line 1
	call	SPACE_NO	

	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
; Fault type
;	FAULT,2		; for short to Vcc
;	FAULT,1		; for short to GND
;	FAULT,0		; open circuit
	btfsc	FAULT,2
	goto	SHORT_Vcc
	btfsc	FAULT,1
	goto	SHORT_GND
	btfss	FAULT,0
	goto	THRES	; check threshold
; OPEN CIRCUIT
	movlw	A'O'
	call	DRV_LCD
	movlw	A'P'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	call	SPACE1
	movlw	A'C'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'C'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	D'16'		; clear line 2
	call	SPACE_NO
	goto	DATA31		; read data again
SHORT_Vcc
	movlw	A'S'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	call	SPACE1
	movlw	A'T'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	call	SPACE1
	movlw	A'V'
	call	DRV_LCD
	movlw	A'c'
	call	DRV_LCD
	movlw	A'c'
	call	DRV_LCD
	movlw	D'16'		; clear line 2
	call	SPACE_NO
	goto	DATA31		; read data again
SHORT_GND
	movlw	A'S'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	call	SPACE1
	movlw	A'T'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	call	SPACE1
	movlw	A'G'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	D'16'		; clear line 2
	call	SPACE_NO
	goto	DATA31		; read data again

; subroutine
;.................................................................
AVG_PROCESS

; bypass averaging when AVERG_COUNT is 7 (no averaging)
	movf	AVERG_COUNT,w
	xorlw	D'7'
	btfss	STATUS,Z
	goto	DO_AVGX
;...
; No Averaging so just transfer values	
	movf	T_COUPLE0,w
	movwf	AV_TEMP0
	movf	T_COUPLE1,w
	movwf	AV_TEMP1
	movlw	B'00011111'	; remove ms bits (clear bit 13)
	andwf	AV_TEMP0,f	
; set bit 13 if positive
	btfss	THERMO_SIGN,0
	bsf		AV_TEMP0,5	; 5 +8 =13
	goto	CAL_ADJ		; adjust for calibration

; Averaging
DO_AVGX	
; Averaging and processing of measured temperature
; store thermocouple value as signed value. Sign bit THERMO_SIGN,0  1 = negative, 0= positive
; swap sign sense for averaging

	movf	T_COUPLE0,w
	movwf	TEMPRTRE0
	movf	T_COUPLE1,w
	movwf	TEMPRTRE1

	movlw	B'00011111'			; remove ms bits (clear bit 13)
	andwf	TEMPRTRE0,f	
; set bit 13 if positive
;
	btfss	THERMO_SIGN,0
	bsf		TEMPRTRE0,5			; 5 +8 =13

; sum up readings
	incf	AV_COUNT,f
; get averaging value
	movf	AVERG_COUNT,w
	call	SUM_LOOK			; lookup table for summation number (n-1 times addition (n= (2 to the power of DIVX) plus 1 (eg D'65' and DIV=6))
	xorwf	AV_COUNT,w
	btfsc	STATUS,Z	
	goto	DIV1

;/////////////////////////////////////////////////////////////////////////////////

; do summation 
; if first value, just transfer values
	movf	AV_COUNT,w
	xorlw	D'1'
	btfss	STATUS,Z
	goto	NEXT_VAL
; transfer of TEMPRTRE0,TEMPRTRE1 to AVG0, AVG1, AVG2
	movf	TEMPRTRE0,w
	movwf	AVG1
	movf	TEMPRTRE1,w
	movwf	AVG2
	return

NEXT_VAL

;add TEMPRTRE0,TEMPRTRE1 to AVG0,AVG1,AVG2

	movf	TEMPRTRE1,w
	addwf	AVG2,f
	btfss	STATUS,C
	goto	N11
	movlw	D'1'
	addwf	AVG1,f		; increase if carry
	btfsc	STATUS,C
	incf	AVG0,f
N11	movf	TEMPRTRE0,w
	addwf	AVG1,f
	btfsc	STATUS,C
	incf	AVG0,f
	return

DIV1 ; divide averaging summation
	incf	AVERG_COUNT,w	; averaging value for division
	movwf	DIVX
DIV_LOOP; divide by 2 per DIVX
	bcf		STATUS,C
	rrf		AVG0,f
	rrf		AVG1,f
	rrf		AVG2,f
	decfsz	DIVX,f
	goto	DIV_LOOP

	movf	AVG1,w
	movwf	AV_TEMP0	; Averaged temperature as signed digital ls byte
	movf	AVG2,w
	movwf	AV_TEMP1	; Averaged temperature as signed digital ls byte

; do calibration by adding or subtracting reference adjustment

CAL_ADJ

; set updated data flag
	bsf		UPDATE,0

;..............................................................................
OFFSET_CAL
; Offset Calibration adjustment
; offset calibration. Use OFF_CAL value to adjust value of averaged thermocouple reading
	btfss	AV_TEMP0,5		; Check thermocouple sign, if clear then is negative
	goto	THERMO_NEG
	btfss	OFF_CAL,5		; if set then positive
	goto	CAL_NEG1		; calibration is negative

; both positive
	movf	OFF_CAL,w
	andlw	B'00011111'	
	addwf	AV_TEMP1,f
	btfsc	STATUS,C
	incf	AV_TEMP0,f
; set as positive
	bsf		AV_TEMP0,5
	movlw	B'00111111'
	andwf	AV_TEMP0,f
	goto	CLEAR1

THERMO_NEG ; reference is negative. 
	btfss	OFF_CAL,5	; Check calibrate, if clear then negative
	goto	BOTH_NEG1	; both are negative

	movf	OFF_CAL,w
	andlw	B'00011111'	; remove sign
	movwf	TEMP
	call	COM_THERMO
	goto	TAKE_REF1

COM_THERMO ; subroutine to complement Thermocouple
; complement 
	comf	AV_TEMP0,f
	comf	AV_TEMP1,f
	movlw	D'1'
	addwf	AV_TEMP1,f
	btfsc	STATUS,C
	incf	AV_TEMP0,f
	movlw	B'00011111'
	andwf	AV_TEMP0,f
	return

TAKE_REF1
; take Thermocouple from cal
; take from cal
	movf	AV_TEMP0,w
	sublw	D'0'
	movwf	AV_TEMP0
	movf	AV_TEMP1,w
	subwf	TEMP,w
	movwf	AV_TEMP1
	btfss	STATUS,C
	decf	AV_TEMP0,f
	btfsc	AV_TEMP0,7			; if set then set as negative
	goto	PROCESS_THERMO
	movlw	B'00011111'
	andwf	AV_TEMP0,f
	bsf		AV_TEMP0,5			; positive
	goto	CLEAR1

PROCESS_THERMO
	movlw	B'00011111'			; negative
	andwf	AV_TEMP0,f
	goto	CLEAR1

CAL_NEG1 
	btfss	AV_TEMP0,5	; Check Thermocouple sign, if set then positive
	goto	BOTH_NEG1
; calibration is negative so take from Thermocouple
	bcf		AV_TEMP0,5
; complement calibration value
	comf	OFF_CAL,w
	addlw	D'1'
	andlw	B'00011111'	; only required digits
	subwf	AV_TEMP1,f		; take from thermocouple
	btfss	STATUS,C	; if carry reduce ms byte
	decf	AV_TEMP0,f
	btfsc	AV_TEMP0,7		; if set then negative
	goto	NEG_PROCESS1
	movlw	B'00011111'
	andwf	AV_TEMP0,f
	bsf		AV_TEMP0,5		; sign for +
	goto	CLEAR1

NEG_PROCESS1
	movlw	B'00011111'		; sign for negative
	andwf	AV_TEMP0,f
	goto	CLEAR1

BOTH_NEG1
; add both without signs and then set as negative

; complement Thermocouple
	call	COM_THERMO		; subroutine to complement Thermocouple

; complement calibration value
	comf	OFF_CAL,w
	addlw	D'1'
	andlw	B'00011111'		; only required digits
;add

	addwf	AV_TEMP1,f
	btfsc	STATUS,C
	incf	AV_TEMP0,f
	movlw	B'00011111'
	andwf	AV_TEMP0,f		; set as negative

; complement 
	call	COM_THERMO		; subroutine to complement Thermocouple

CLEAR1 ; end of each averaging
	clrf	AV_COUNT
	bsf		AV_SIGN,0	; initially +
	clrf	AVG0		; values zero
	clrf	AVG1
	clrf	AVG2
	incf	TOGGLE,f	; selects upper and lower slashes indicating update at 'measured temp' 

;......................................................................................

; Thermocouple non-linearity correction using lookup table in Flash memory
;...................................................................................................
; ****TEST table with values
; 300 degrees C is H24B0
; 800 degrees C is H2C80
; 1600 H3900 tests out of range for linearisation table
; 1FD8 = -10 degrees thermocouple
;	movlw	H'39'	; 
;	movwf	AV_TEMP0
;	movlw	H'00'
;	movwf	AV_TEMP1
; ref = 20 degrees = H50, 0 degrees = H'00'
;	clrf	REFERENCE0
;	movlw	H'00'
;	movwf	REFERENCE1
;	clrf	REF_SIGN	
; End Test
;..................................................................................................

; if linearisation not selected, bypass
	btfsc	HI_LO_AUT,2
	return
	btfss	PORTA,0		; if down switch is pressed, bypass correction (thus showing non-linearised thermostat) but only if selected (HI_LO_AUT,2 clear)
	return
; Correct readings
; corrected readings address matches thermometer value when the thermometer value is divided by 2
; thermometer value is in AV_TEMP0, AV_TEMP1 as signed digital value with bit 5 of ms byte the sign (set is positive)
; move address by cold junction temperature (after divide by 2)for thermocouple reading only  
; shift thermometer value (/2)

	movf	AV_TEMP0,w
	movwf	WORKING0
	movf	AV_TEMP1,w
	movwf	WORKING1

	bcf		STATUS,C
	rrf		WORKING0,f
	rrf		WORKING1,f	
; adjust for cold junction temperature for negative and positive degrees C

; divide by 2
	bcf		STATUS,C
	rrf		REFERENCE0,w
	rrf		REFERENCE1,w	; reduces to 8 bits in reference1 
; if negative 
	btfsc	REF_SIGN,0	; if set then negative 
	goto	NEG_CORR
; reduce WORKING0,1 by the reference value/2. Shifts along correction lookup table address toward lower address
	subwf	WORKING1,f
	btfss	STATUS,C	; if carry then reduce working 0
	decf	WORKING0,f
	goto	LOOK_CORR
NEG_CORR
; increase WORKING0,1 by the reference value/2. Shifts along correction lookup table address toward higher address
	movwf	TEMP_REF
	comf	TEMP_REF,f
	incf	TEMP_REF,w
	addwf	WORKING1,f
	btfsc	STATUS,C
	incf	WORKING0,f

LOOK_CORR
; look up temperature from flash
	movf 	WORKING0,w
	movwf	READADDMS	; ms
	movf	WORKING1,w
	movwf	READADDLS	; ls
	call	READ
	movwf	CORR_VAL	; correction value ms bit 7 set for negative, clear for +
; get ms byte for out of range detection (ie if 3F)
	movf	TEMP_VAL,w	; ms byte from reading lookup list
	movwf	LIN_RANGE

; gives add on or subtract correction value in 0.25 degree steps
; if CORR_VAL,7 is set, subtract from AV_TEMP0,1
; if CORR_VAL,7 clear add to AV_TEMP0,1
	btfss	CORR_VAL,7
	goto	ADD_COR
; subtract correction value
	bcf		CORR_VAL,7	; remove sign
	movf	CORR_VAL,w
	subwf	AV_TEMP1,f
	btfss	STATUS,C
	decf	AV_TEMP0,f
	return
ADD_COR
	movf	CORR_VAL,w
	addwf	AV_TEMP1,f
	btfsc	STATUS,C
	incf	AV_TEMP0,f
	return

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; do 16-bit Thermometer / Threshold comparison for relay on/off according to heat or cool 
; THRESHOLD
THRES
; do threshold when averaging is done
	btfss	UPDATE,0	; when set run threshold comparison (new data)
	goto	DRIVE
	clrf	UPDATE		; update flag shows new data. Cleared each use

; if AV_TEMP0,1 is FFFF then no threshold test
	movf	AV_TEMP0,w
	xorlw	H'FF'
	btfss	STATUS,Z
	goto	THRESHX
	movf	AV_TEMP1,w
	xorlw	H'FF'
	btfsc	STATUS,Z
	goto	DRIVE	; avoid comparison

THRESHX
; thermocouple value loaded as signed value with data has ms bit as the sign with 1 = negative, 0= positive
; if this sign bit is swapped then temperature ranges from 0111 0000 0110 00 (-250 degrees) to 1110 0100 0000 00 (1600 degrees)
; not an actual temperature but by way of comparison is easier
; if positive value, set bit 13, if negative value clear bit 13
; for the averaging AV_TEMP0, AV_TEMP1 are in this format as well as THERM_STAT0, THERM_STAT1

; so compare thermocouple AV_TEMP0,AV_TEMP1 with Thermostat setting THERM_STAT0, THERM_STAT1

DO_THRESH
; if HI_LO_AUT,0 is set for high threshold
	btfss	HI_LO_AUT,0
	goto	COOL_N
HEAT_N
; if relay is on
	btfss	PORTA,4
	goto	RLY_ON_H
; if relay is on, then relay off if AV_TEMP0,AV_TEMP1 => THERM_STAT0, THERM_STAT1
	movf	THERM_STAT0,w	; thermostat setting ms byte
	subwf	AV_TEMP0,w		; temperature  ms byte
	movwf	TEMPORARY		; keep value
	movf	THERM_STAT1,w	; thermostat setting ls byte
	subwf	AV_TEMP1,w		; temperature ls byte
	btfss	STATUS,C		; check carry
	decf	TEMPORARY,f
	btfss	TEMPORARY,7		; if clear then AV_TEMP0,AV_TEMP1 => THERM_STAT0, THERM_STAT1
	goto	RLY_OFF1
	clrf	RLY_COUNT
	goto	DRIVE			; drive display according to MENU

;............................................
; Switch RELAY off. relay counter provides glitch protection as two off signals are required before relay goes off
RLY_OFF1
; if already off clear RLY_COUNT
	btfss	PORTA,4
	goto	CLEARX
; relay on/off logic for an off.
; on, increment counter (RLY_COUNT)
	incf	RLY_COUNT,f 
; when bit 2 is set ( 3 counts later), switch off relay and clear RLY_COUNT
	btfss	RLY_COUNT,2
	goto	DRIVE		; do not switch off or clear RLY_COUNT

; relay off
	movlb	D'2'		; latch, bank 2
	bcf		LATA,4		; relay off
	movlb	D'0'		; bank 0
CLEARX
	clrf	RLY_COUNT
	goto 	DRIVE
;..........................................................

; if relay is off relay switches on when AV_TEMP0,AV_TEMP0 plus HYSTERESIS =< THERM_STAT0, THERM_STAT1
RLY_ON_H
; add hysteresis
	movf	AV_TEMP0,w		; get averaged ms byte and store
	movwf	ADDITION0
	movf	HYSTERESIS,w
	addwf	AV_TEMP1,w
	movwf	ADDITION1		; storage
	btfsc	STATUS,C		; if carry is set, add 1 to ms byte
	incf	ADDITION0,f		; store

	movf	THERM_STAT0,w	; thermostat ms byte
	subwf	ADDITION0,w		; temperature plus hysteresis
	movwf	TEMPORARY
	movf	THERM_STAT1,w	; thermostat ls byte
	subwf	ADDITION1,w		; temperature plus hysteresis
	btfss	STATUS,C		; check carry
	decf	TEMPORARY,f
	btfsc	TEMPORARY,7		; if set then temperature plus hysteresis < Thermostat
	goto	RLY_ON1
	iorwf	TEMPORARY,w		; if both zero then equal 
	btfsc	STATUS,Z
	goto	RLY_ON1
	clrf	RLY_COUNT
	goto	DRIVE
; set relay on 
	goto	RLY_ON1

COOL_N
; HI_LO_AUT,0 is clear
; if relay is on
	btfss	PORTA,4
	goto	RLY_OFF_C
; if relay is on, then relay off if AV_TEMP0,AV_TEMP1 =< THERM_STAT0, THERM_STAT1
	movf	THERM_STAT0,w	; thermostat setting ms byte
	subwf	AV_TEMP0,w		; temperature  ms byte
	movwf	TEMPORARY		; keep value
	movf	THERM_STAT1,w	; thermostat setting ls byte
	subwf	AV_TEMP1,w		; temperature ls byte
	btfss	STATUS,C		; check carry
	decf	TEMPORARY,f
	btfsc	TEMPORARY,7		; if set then AV_TEMP0,AV_TEMP1 =< THERM_STAT0, THERM_STAT1
	goto	RLY_OFF1
	iorwf	TEMPORARY,w		; if both zero then =
	btfsc	STATUS,Z
	goto	RLY_OFF1
	clrf	RLY_COUNT
	goto	DRIVE			; drive display according to MENU

; if relay is off relay switches on when AV_TEMP0,AV_TEMP0 minus HYSTERESIS >= THERM_STAT0, THERM_STAT1
RLY_OFF_C
; subtract hysteresis
	movf	AV_TEMP0,w		; get averaged ms byte and store
	movwf	ADDITION0
	movf	HYSTERESIS,w
	subwf	AV_TEMP1,w
	movwf	ADDITION1		; storage
	btfss	STATUS,C		; if carry is clear, add 1 to ms byte
	decf	ADDITION0,f		; store

	movf	THERM_STAT0,w	; thermostat ms byte
	subwf	ADDITION0,w		; temperature minus hysteresis
	movwf	TEMPORARY
	movf	THERM_STAT1,w	; thermostat ls byte
	subwf	ADDITION1,w		; temperature minus hysteresis
	btfss	STATUS,C		; check carry
	decf	TEMPORARY,f
	btfss	TEMPORARY,7		; if clear then temperature plus hysteresis > Thermostat
	goto	RLY_ON1
	iorwf	TEMPORARY,w		; if both zero then =
	btfsc	STATUS,Z
	goto	RLY_ON1
	clrf	RLY_COUNT
	goto	DRIVE

; set relay on 
RLY_ON1
	movf	FAULT,w
	btfss	STATUS,Z
	goto	RLY_OFF1

; if already on clear RLY_COUNT
	btfsc	PORTA,4
	goto	CLEARZ
; relay on/off logic for an on.
; off, increment counter (RLY_COUNT)
	incf	RLY_COUNT,f 
; when bit 2 is set (3 counts later), switch on relay and clear RLY_COUNT
	btfss	RLY_COUNT,2
	goto	DRIVE		; do not switch off or clear RLY_COUNT

; relay on
	movlb	D'2'		; latch, bank 2
	bsf		LATA,4		; relay on
	movlb	D'0'		; bank 0
CLEARZ
	clrf	RLY_COUNT
;	goto 	DRIVE

;........................................................................................................

DRIVE
; drive display depending on MENU. 
; Values of temperature and hysteresis and Thermostat temperature require binary to BCD conversion
; Find MENU setting

	movf	MENU,w
	btfsc	STATUS,Z
	goto	MEASURED_TEMPERATURE; MENU=0 (Thermometer)

	movf	MENU,w
	xorlw	D'2'
	btfsc	STATUS,Z
	goto	THERMOSTAT_SET		; MENU=2

	movf	MENU,w
	xorlw	D'3'
	btfsc	STATUS,Z
	goto	HYSTER_ESIS			; MENU=3

	movf	MENU,w
	xorlw	D'6'
	btfsc	STATUS,Z
	goto	HI_LO_SET			; MENU=6

	movf	MENU,w
	xorlw	D'7'
	btfsc	STATUS,Z
	goto	SHOW_MENU_RETURN	; MENU=7

	movf	MENU,w
	xorlw	D'5'
	btfsc	STATUS,Z
	goto	AVERAG				; MENU=5

	movf	MENU,w
	xorlw	D'4'
	btfsc	STATUS,Z
	goto	DIMMING	;/brightness; MENU=4
	
	movf	MENU,w
	xorlw	D'1'
	btfsc	STATUS,Z
	goto	OFFSET	; offset adjust; MENU=1

	movf	MENU,w
	xorlw	D'9'
	btfsc	STATUS,Z
	goto	AMBIENT	; cold junction	; MENU=9

	movf	MENU,w
	xorlw	D'8'
	btfsc	STATUS,Z
	goto	LINEARISE	; linearisation	; MENU=8
	
	
	clrf	MENU				; if MENU >9 then clear
	goto	MEASURED_TEMPERATURE; MENU=0

;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

AMBIENT ; cold junction reference
; if switch flag is not zero bypass display update rate
	movf	SW_FLG,w
	btfss	STATUS,Z
	goto	S_A
	movf	DISP_COUNT,w;counter is incremented in interrupt each 10ms
	sublw	D'70'		; ensure >700ms between display update
	btfsc	STATUS,C	; if >70 then read data
	goto	DATA31
	clrf	DISP_COUNT
S_A ; show ambient
; show ambient temperature
; REF_SIGN		; reference temperature sign (1=negative)
; REFERENCE0,1	; reference (Ambient) temperature

	movlw	H'80'		; address line 1 pos 0
	call	LOAD

; write Cold Junction
	movlw	A'C'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'L'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	call	SPACE1
	movlw	A'J'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'C'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	D'16'		; clear line 1
	call	SPACE_NO

	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	SPACE1

; show no sign when zero
	movf	REFERENCE0,w
	btfss	STATUS,Z
	goto	SIGND2
	movf	REFERENCE1,w
	btfss	STATUS,Z
	goto	SIGND2
	call	SPACE1
	goto	VIA_SIGN2
SIGND2
	movlw	H'20'		; choices: H'20' for space or use A'+' for plus indication 
	btfsc	REF_SIGN,0
	movlw	A'-'
	call	DRV_LCD		; drive sign
VIA_SIGN2
; remove decimal point values. shift into BIN_1 and TEMP 
	clrf	TEMP
	bcf		STATUS,C
	rrf		REFERENCE0,w
	movwf	BIN_0		; temporary
	rrf		REFERENCE1,w
	movwf	BIN_1
	btfsc	STATUS,C	; if carry set, set bit 0 
	bsf		TEMP,0	
	bcf		STATUS,C
	rrf		BIN_0,f		; 
	rrf		BIN_1,f
	btfsc	STATUS,C	; if carry set, set bit 1 
	bsf		TEMP,1	
; BIN_1 has temperature. TEMP has dp values in bits 0 and 1

	btfss	REF_SIGN,0	; if set then -

	goto	REF_T
	comf	BIN_1,w
	andlw	B'01111111'
	movwf	BIN_1
	comf	TEMP,w
	andlw	B'00000011'
	movwf	TEMP
	movlw	D'1'
	addwf	TEMP,f
	btfsc	TEMP,2	; if set increase REF_TEMP (BIN_1)
	incf	BIN_1,f

REF_T
; get temperature values
	
DO_BCD_R
	
	clrf	BIN_0
	call	BCD

	swapf	BCD_1,w
	andlw	B'00001111'	; ms digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP0

	movf	BCD_1,w	
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP1

	swapf	BCD_2,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP2

	movf	BCD_2,w	
	andlw	B'00001111'	; ls digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP3

	call	DIGITS1		; drives LCD with leading zero blanking

	movlw	A'.'
	call	DRV_LCD

; value after decimal point

	movf	TEMP,w
	andlw	B'00000011'	; for reference there are 2-bits after DP, for 0.25 degree steps 
	movwf	BIN_0		; temporary
	call	DECIMAL_VALUES ; generic code to display .00, .25, .5 .75 degree values
SPACES_END
	movlw	D'16'		; clear line 1
	call	SPACE_NO
	goto	DATA31

;.....................................................
OFFSET
; write OFFSET ADJ.
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	call	SPACE1
	movlw	A'A'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	A'J'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD

	movlw	D'16'		; clear line 1
	call	SPACE_NO

; line 2
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	D'3'		; clear line 1
	call	SPACE_NO
; show temperature adjustment value
	movlw	H'20'		; H'20' for space or A'+'	for +
	btfss	OFF_CAL,5	; if set show space or +
	movlw	A'-'		; -
	call	DRV_LCD

	btfsc	OFF_CAL,5	; check for sign
	goto	OFF_SET
	comf	OFF_CAL,w
	movwf	BIN_1
	movlw	D'1'
	addwf	BIN_1,w
	andlw	B'00011111'
	movwf	TEMP
	movwf	BIN_1
	goto	DO_BCD_X
OFF_SET; offset
; get temperature values
	
	movf	OFF_CAL,w
	andlw	B'00011111'
	movwf	TEMP
	movwf	BIN_1
DO_BCD_X
; move right 2x for before DP value
	bcf		STATUS,C
	rrf		BIN_1,f
	bcf		STATUS,C
	rrf		BIN_1,f
	clrf	BIN_0
	call	BCD

	swapf	BCD_1,w
	andlw	B'00001111'	; ms digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP0

	movf	BCD_1,w	
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP1

	swapf	BCD_2,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP2

	movf	BCD_2,w	
	andlw	B'00001111'	; ls digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP3

	call	LOAD4		; drives LCD with leading zero blanking

	movlw	A'.'
	call	DRV_LCD

; value after decimal point

	movf	TEMP,w
	andlw	B'00000011'	; for reference there are 2-bits after DP, for 0.25 degree steps 
	movwf	BIN_0		; temporary
	call	DECIMAL_VALUES ; generic code to display .00, .25, .5 .75 degree values
; spaces	
	goto	SPACES_END

;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
LINEARISE
; HI_LO_AUT, bit 2
; SHOW on or off
; write LINEARISATION
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'L'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	D'16'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD

	btfss	HI_LO_AUT,2	; when set show 'off'
	goto	SHOW_ON
; show OFF
	movlw	A'O'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
; spaces	
	goto	SPACES_END
SHOW_ON ; ON
	movlw	A'O'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
; spaces	
	goto	SPACES_END
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

HI_LO_SET
; HI_LO_AUT, bit 0
; SHOW Threshold heating or cooling
; write Thermostat
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	
	movlw	D'16'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD

	btfss	HI_LO_AUT,0	; when set show high
	goto	SHOW_LOW
; show HEAT
	movlw	A'H'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
; spaces	
	goto	SHOW_ING
SHOW_LOW ; COOL
	movlw	A'C'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'L'
	call	DRV_LCD
SHOW_ING ; ING
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'G'
	call	DRV_LCD
; spaces	
	goto	SPACES_END
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
SHOW_MENU_RETURN
; HI_LO_AUT, bit 1
; Menu return
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A':'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	D'2'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	
	movlw	A'T'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	call	SPACE1
	movlw	A'M'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A':'
	call	DRV_LCD
	call	SPACE1
	movlw	A'O'
	call	DRV_LCD
	btfss	HI_LO_AUT,1	; when set ON
	goto	SHOW_OFF
	movlw	A'N'		; normally
	call	DRV_LCD
	goto	SPACES_END
SHOW_OFF
	movlw	A'F'		; OFF
	call	DRV_LCD
	movlw	A'F'		; OFF
	call	DRV_LCD
; spaces	
	goto	SPACES_END
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

HYSTER_ESIS
; HYSTERESIS	; Hysteresis 8-bit for 32 degree maximum with 2 bit decimal point values
; write Hysteresis
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'Y'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	
	movlw	D'16'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	SPACE1

	clrf	BIN_0		; no more than 255 (in BIN_1)
	bcf		STATUS,C
	rrf		HYSTERESIS,w	; remove values after decimal
	movwf	BIN_1
	bcf		STATUS,C
	rrf		BIN_1,f
	call	BCD

	swapf	BCD_1,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP0

	movf	BCD_1,w	
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP1

	swapf	BCD_2,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP2

	movf	BCD_2,w	
	andlw	B'00001111'	; ls digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP3
	call	DIGITS		; drives LCD with leading zero blanking

	movlw	A'.'
	call	DRV_LCD

; value after decimal point
	movf	HYSTERESIS,w
	andlw	B'00000011'
	movwf	BIN_0		; temporary
	call	DECIMAL_VALUES

; show Thermostat on/off
THERMO_ON_OFF
	movlw	D'5'		; clear line 
	call	SPACE_NO

	movlw	H'CF'		; address line 2 pos 15
	call	LOAD

; show thermostat state

; show relay on
	btfss	PORTA,4		; is relay on 
	goto	THERM_OFF	; thermostat off

; if MENU is not zero, use slowdown counter
	movf	MENU,w
	btfsc	STATUS,Z
	goto	SET_DIR
	incf	BAR_GO,f
	btfss	BAR_GO,2
	goto	DIR1		; no change until counter ready
	clrf	BAR_GO
SET_DIR
; set direction
	btfss	HI_LO_AUT,0
	goto	DIR_DEC
	incf	CHARGE,f
	movf	CHARGE,w
	sublw	D'6'
	movlw	D'1'
	btfss	STATUS,C
	movwf	CHARGE	
	goto	DIR1
DIR_DEC
	decfsz	CHARGE,f
	goto	DIR1
	movlw	H'6'
	movwf	CHARGE
DIR1
	movf	CHARGE,w
	andlw	B'00000111'	; show animated bar
	movwf	CHARGE
	call	DRV_LCD
	goto	SPACES_END
THERM_OFF
	movlw	H'0'		; H'0' for open rectangle, H'20' for nothing. H'FF' for full rectangle block
	call	DRV_LCD
	goto	SPACES_END

;////////////////////////////////////////////
DECIMAL_VALUES ; generic code subroutine do after decimal point
; bits 0 and 1
;00=0.00
	movf	BIN_0,w
	btfsc	STATUS,Z	; both bits 0 and 1 are 0
	goto	DRV_00	
;01=0.25
	btfss	BIN_0,1	; if 0 then 0.25
	goto	DRV_25	; only bit 1 is zero
;10=0.50
	btfss	BIN_0,0	; of 0 then 0.50
	goto	DRV_50	; only bit 0 is zero
;11=0.75 ; both bits are 1
DRV_75
	movlw	H'37'
	call	DRV_LCD
	movlw	H'35'
	call	DRV_LCD
	goto	DEG_SYMBOL
DRV_50
	movlw	H'35'
	call	DRV_LCD
	movlw	H'30'
	call	DRV_LCD
	goto	DEG_SYMBOL
DRV_25
	movlw	H'32'
	call	DRV_LCD
	movlw	H'35'
	call	DRV_LCD
	goto	DEG_SYMBOL
DRV_00
	movlw	H'30'
	call	DRV_LCD
	movlw	H'30'
	call	DRV_LCD

DEG_SYMBOL
	movlw	H'DF'		; degrees symbol
	call	DRV_LCD
; temperature write degrees C
	movlw	A'C'		; C
	call	DRV_LCD	
	return

;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,	

THERMOSTAT_SET
	movlw	H'80'		; address line 1 pos 0
	call	LOAD

; write Thermostat

	movlw	A'T'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	call	SPACE1
	movlw	A'S'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	D'16'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
; get temperature sign from THERM_STAT0,5
; if value = 0 SHOW no sign
	movf	THERM_STAT0,w
	andlw	B'00011111'	; all but  bit 5,6,7
	btfss	STATUS,Z
	goto	SIGND
	movf	THERM_STAT1,w
	btfss	STATUS,Z
	goto	SIGND
	call	SPACE1
	goto	VIA_SIGN
SIGND
	movlw	H'20'		; choices: H'20' for space or use A'+' for plus indication 
	btfss	THERM_STAT0,5
	movlw	A'-'
	call	DRV_LCD		; drive sign
VIA_SIGN

; if negative complement values
	btfsc	THERM_STAT0,5
	goto	TEMPERATURE1

	comf	THERM_STAT0,w
	movwf	BIN_0
	comf	THERM_STAT1,w
	movwf	BIN_1
	movlw	D'1'
	addwf	BIN_1,f
	btfsc	STATUS,C	; if carry increment BIN_0
	incf	BIN_0,f
	goto	DO_BCDT

TEMPERATURE1
	movf	THERM_STAT1,w
	movwf	BIN_1
	movf	THERM_STAT0,w
	movwf	BIN_0
DO_BCDT
	movlw	B'00011111'
	andwf	BIN_0,f		; only 14 bits and remove sign bit 5

; roll right for /4 (so the ls bits are taken out and are the after decimal point values)
	
	bcf		STATUS,C
	rrf		BIN_0,f
	rrf		BIN_1,f
	bcf		STATUS,C
	rrf		BIN_0,f
	rrf		BIN_1,f

	call	BCD
	swapf	BCD_1,w
	andlw	B'00001111'	; ms digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP0

	movf	BCD_1,w	
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP1

	swapf	BCD_2,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP2

	movf	BCD_2,w	
	andlw	B'00001111'	; ls digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP3

	call	DIGITS		; drive LCD with leading zero blanking

	movlw	A'.'
	call	DRV_LCD
; value after decimal point
	movf	THERM_STAT1,w
	andlw	B'00000011'	; just the two ls bits
	movwf	BIN_0		; temporary
; if negative complement values
	btfsc	THERM_STAT0,5
	goto	DPX
	comf	BIN_0,f
	incf	BIN_0,f

DPX
	call	DECIMAL_VALUES ; generic code to display .00, .25, .50 .75 degree values
; show Thermostat on/off
	goto	THERMO_ON_OFF

;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,	

MEASURED_TEMPERATURE

	movf	DISP_COUNT,w;counter is incremented in interrupt each 10ms
	sublw	D'70'		; ensure >700ms between updates
	btfsc	STATUS,C	; if >70 then read data
	goto	DATA31
	clrf	DISP_COUNT

	movlw	H'80'		; address line 1 pos 0
	call	LOAD		; curser position
; check if linearised
	btfsc	HI_LO_AUT,2	; if set no linearisation
	goto	AVL
	btfss	PORTA,0		; down switch pressed so no linearisation
	goto	AVL
; linearised so check if linearisation is out of range
	movf	LIN_RANGE,w
	xorlw	H'3F'		; if 3F then out of range data
	btfsc	STATUS,Z
	goto	SHOW_OUT_RANGE

AVL
; if averaging is 2 or 4 (0 or 1 for AVERG_COUNT) clear toggle so no update indication
	movf	AVERG_COUNT,w; ranges from 0-7 for averages over counts 2,4,8,16,32,64,127,1
	sublw	D'1'
	btfsc	STATUS,C
	goto	CL0
; if 7 also stays on
	movf	AVERG_COUNT,w
	xorlw	D'7'
	btfsc	STATUS,Z
	goto	CL0
; otherwise toggle slash high and low
	movlw	H'A4'		; low slash
	btfss	TOGGLE,0	; change indicating update at each change. 
	movlw	H'60'		; high slash
	call	DRV_LCD	
	goto	NL0
CL0	call	SPACE1
NL0	call	SPACE1
	movlw	A'T'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	D'5'		; clear line
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD

; if AV_TEMP0,1 is FFFF then show dashes
	movf	AV_TEMP0,w
	xorlw	H'FF'
	btfss	STATUS,Z
	goto	DSP_READ
	movf	AV_TEMP1,w
	xorlw	H'FF'
	btfss	STATUS,Z
	goto	DSP_READ
;SHOW DASHES at startup
	movlw	A'-'
	call	DRV_LCD
	movlw	A'-'
	call	DRV_LCD
	movlw	A'-'
	call	DRV_LCD
	movlw	A'-'
	call	DRV_LCD
	movlw	A'-'
	call	DRV_LCD
		
	movlw	D'16'		; clear line 
	call	SPACE_NO
	goto	DATA31		; read data again
DSP_READ
 	movf	AV_TEMP0,w
	andlw	B'00011111'	; remove sign bit
	btfss	STATUS,Z
	goto	SIGND1
	movf	AV_TEMP1,w
	btfss	STATUS,Z
	goto	SIGND1
	call	SPACE1
	goto	VIA_SIGN1
SIGND1
	movlw	H'20'		; choices: H'20' for space or use A'+' for plus indication 
	btfss	AV_TEMP0,5	; 
	movlw	A'-'
	call	DRV_LCD		; drive sign
VIA_SIGN1

; if negative complement values
	btfsc	AV_TEMP0,5
	goto	TEMPR1

	comf	AV_TEMP0,w
	andlw	B'00000111'
	movwf	BIN_0
	comf	AV_TEMP1,w
	movwf	BIN_1
	movlw	D'1'
	addwf	BIN_1,f
	btfsc	STATUS,C	; if carry increment BIN_0
	incf	BIN_0,f
	goto	DO_BCDM

TEMPR1
; get temperature values
	movf	AV_TEMP0,w
	movwf	BIN_0
	bcf		BIN_0,5		; clear sign bit
	movf	AV_TEMP1,w
	movwf	BIN_1
; remove dp values
DO_BCDM
	bcf		STATUS,C
	rrf		BIN_0,f
	rrf		BIN_1,f
	bcf		STATUS,C
	rrf		BIN_0,f
	rrf		BIN_1,f

	call	BCD

	swapf	BCD_1,w
	andlw	B'00001111'	; ms digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP0

	movf	BCD_1,w	
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP1

	swapf	BCD_2,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP2

	movf	BCD_2,w	
	andlw	B'00001111'	; ls digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP3

	call	DIGITS		; drives LCD with leading zero blanking

	movlw	A'.'
	call	DRV_LCD

; value after decimal point

	movf	AV_TEMP1,w
	andlw	B'00000011'	; just the two ls bits
	movwf	BIN_0		; temporary

	btfsc	AV_TEMP0,5
	goto	DPY
	comf	BIN_0,f
	incf	BIN_0,f
DPY
	call	DECIMAL_VALUES ; generic code to display .00, .25, .5, .75 degree values

; show Thermostat on/off
	goto	THERMO_ON_OFF

; out of range linearisation
SHOW_OUT_RANGE
; write LINEARISATION

	movlw	A'L'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	D'16'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'G'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	call	SPACE1
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD	
	goto	SPACES_END
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
DIMMING ; /brightness

; write BRIGHTNESS
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'B'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'G'
	call	DRV_LCD
	movlw	A'H'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
		
	movlw	D'16'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movf	DIM_VAL,w	; 
	btfsc	STATUS,Z	; if zero display 'OFF'
	goto	DISP_OFF
	movwf	TEMPN		; temporary for adding blocks on bargraph of length based on DIM_VAL
	btfsc	STATUS,Z	; if zero clear bar display	
	goto	SPACES_END
BLOCK ; write block
	movlw	H'FF'		; block for bargraph
	call	DRV_LCD
	decfsz	TEMPN,f
	goto	BLOCK	
	goto	SPACES_END
DISP_OFF
	movlw	A'O'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
	goto	SPACES_END
; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

AVERAG ; number of samples for averaging
; write Averaging Over xxx Measurements
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'V'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'G'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'G'
	call	DRV_LCD
	call	SPACE1
	movlw	A'O'
	call	DRV_LCD
	movlw	A'V'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	D'5'		; clear line 1
	call	SPACE_NO

; new line
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movf	AVERG_COUNT,w	; 
	call	SUM_LOOK	; get averaging sample total 
	movwf	BIN_1
	decf	BIN_1,f		; reduce by 1 to show true average count
	clrf	BIN_0
	
	call	BCD

	movf	BCD_1,w	
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP1

	swapf	BCD_2,w
	andlw	B'00001111'	; next digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP2

	movf	BCD_2,w	
	andlw	B'00001111'	; ls digit
	iorlw	H'30'		; ASCII conversion
	movwf	DISP3

	call	DIGITS1		; drives LCD with leading zero blanking

	call	SPACE1
	movlw	A'M'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
; if AVERG_COUNT is 7 bypass the 'S' as 1 count is not plural
	movf	AVERG_COUNT,w
	xorlw	D'7'
	btfsc	STATUS,Z
	goto	SPACES_END
	movlw	A'S'
	call	DRV_LCD
	goto	SPACES_END

; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

DIGITS; drives display with 4-digits and leading zero blanking
	movf	DISP0,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call	SPACE1		; leading 0's to space
DIGITS1
	movf	DISP1,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call	SPACE1		; leading 0's to space
	movf	DISP2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD3
	call	SPACE1	
	goto	LOAD4
LOAD1
	movf	DISP0,w
	call	DRV_LCD
LOAD2
	movf	DISP1,w
	call	DRV_LCD
LOAD3
	movf	DISP2,w
	call	DRV_LCD
LOAD4
	movf	DISP3,w
	call	DRV_LCD
	return

; add space/spaces in display

SPACE_NO
	movwf	SPACE_COUNT
SPACE_NO_LOOP
	movlw	H'20'		; space
	call	DRV_LCD
	decfsz	SPACE_COUNT,f
	goto	SPACE_NO_LOOP
	return
SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return


; delay loop 

DELAYms ; 120ms
	movlw	D'223'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

; initialise display

INIT_LC
	movlb	H'02'		; Bank LATA-C
	movlw	B'00110000'	; DB4 and DB5 high (via RB4,RB5) to initialise module
	movwf	LATB
	nop
		
	bsf		LATC,2		; enable high
	nop
	bcf		LATC,2		; low
	movlb	H'00'		; bank 0
	return

; preload display commands (4-bit) 

LOAD
	movlb	H'02'		; Bank LATA-C
	movwf	TEMP_VAL	; all banks store of data for later
	andlw	H'F0'		; ms bits first
; place ms bits of display commands in portB
	movwf	LATB		; load data lines	

	bcf		LATC,1		; register select low
	nop
	bsf		LATC,2		; enable set
	nop
	bcf		LATC,2		; enable clear
	swapf	TEMP_VAL,w	; lower bits to ms side
	andlw	H'F0'		; get lower bits

; place ls 4-bits display commands in portB
	movwf	LATB		; load data lines	

	bcf		LATC,1		; register select low
	nop
	bsf		LATC,2		; enable set
	nop
	bcf		LATC,2		; enable clear

	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movlb	H'02'		; Bank LATA-C
	movwf	TEMP_VAL	; all banks store of data for later
	andlw	H'F0'		; ms bits first
; place ms bits of display commands in portB
	movwf	LATB		; load data lines	

	bsf		LATC,1		; register select high
	nop
	bsf		LATC,2		; enable set
	nop
	bcf		LATC,2		; enable clear
	swapf	TEMP_VAL,w	; lower bits to ms side
	andlw	H'F0'		; get lower bits

; place ls 4-bits display commands in portB
	movwf	LATB		; load data lines	

	bsf		LATC,1		; register select high
	nop
	bsf		LATC,2		; enable set
	nop
	bcf		LATC,2		; enable clear


BUS_CK ; time for display to finish updating data
	movlb	D'0'		; bank 0
	movlw 	D'2'		; 
	movwf	STORE1		; delay values
	movlw	D'255'		; delay for busy flag to clear
	goto	DELDSP

; character generation 8 sepaarate characters possible
CHARACTR_GEN

	movlw	B'01000000'	; address 0 for Character RAM
	call	LOAD		; character gen 1 
; 0. open rectangle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; bar graph cycle

; 1. bar cycle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; 2. bar cycle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; 3. bar cycle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; 4. bar cycle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; 5. bar cycle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; 6. bar cycle
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD

	return
;....................................................................
; read data memory
READ; 'w' has read data

	movlb	D'3'		;  bank 3 
	movf	READADDMS,w 
	movwf 	PMADRH		; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 		; ls Byte of Program Address to read
	bcf		PMCON1,CFGS	; avoid configuration space
	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
	movf	PMDATH,w 	; ms Byte of Program data 
	movwf	TEMP_VAL	; ms byte of data in TEMP_VAL
	movf	PMDATL,w 	; ls Byte of Program data in 'w'
	movlb	D'0'		; bank 0
	return

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

; Math routines
    
; Subroutine to convert from 16-bit binary to 3-digit BCD (packed)
; Binary value is in BIN_0,BIN_1. Most significant byte is BIN_0  
; Result in BCD is in BCD_0 BCD_1 & BCD_2.  
; BCD_0 is MSB, BCD_2 is LSB

BCD:
    bcf     STATUS,C	; clear carry bit
	movlw	D'16'
	movwf	CNT_16		; 16 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0
    clrf    BCD_2
LOOPBCD:
    rlf     BIN_1,f		; shift left binary registers
    rlf     BIN_0,f
    rlf     BCD_2,f
	rlf     BCD_1,f		; 
	rlf     BCD_0,f		; shift left BCD registers
	decfsz	CNT_16,f	; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust
	return              ; completed decimal to BCD operation

; decimal adjustment

DECADJ:
; for	BCD_2           ; BCD LSB address
    movlw	D'3'        ; w has 03 
	addwf	BCD_2,w		; add 03 to BCD2 register 
	movwf	TEMPN		; store w
	btfsc	TEMPN,3		; test if >7
	movwf	BCD_2		; save in LS nibble
	movlw	H'30'       ; 30 for MS nibble
	addwf	BCD_2,w		; add 30 to BCD2 register
	movwf	TEMPN		; store w in temp
	btfsc	TEMPN,7		; test if >7
	movwf	BCD_2		; save in MS nibble
; for	BCD_1           ; BCD mid address
    movlw	D'3'          ; w has 03 
	addwf	BCD_1,w		; add 03 to BCD1 register 
	movwf	TEMPN		; store w
	btfsc	TEMPN,3		; test if >7
	movwf	BCD_1		; save in LS nibble
	movlw	H'30'       ; 30 for MS nibble
	addwf	BCD_1,w		; add 30 to BCD1 register
	movwf	TEMPN		; store w in temp
	btfsc	TEMPN,7		; test if >7
	movwf	BCD_1		; save in MS nibble
; for	BCD_0           ; BCD MSB address (not required)
	movlw	D'3'        ; w has 03 
	addwf	BCD_0,w		; add 03 to BCD0 register 
	movwf	TEMPN		; store w
	btfsc	TEMPN,3		; test if >7
	movwf	BCD_0		; save in LS nibble
	movlw	H'30'       ; 30 for MS nibble
	addwf	BCD_0,w		; add 30 to BCD0 register
	movwf	TEMPN		; store w in temp
	btfsc	TEMPN,7		; test if >7
	movwf	BCD_0		; save in MS nibble
  
	goto	LOOPBCD




 end